<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Common;
use App\Models\Classification;
use App\Models\Level;
use App\Models\Audio_Quiz_Leaderboard;
use App\Models\Skill;
use App\Models\User;
use Illuminate\Http\Request;
use Exception;

class AudioLeaderboardController extends Controller
{
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {
            $params['category'] = Category::orderBy('sort_order', 'asc')->latest()->get();
            $params['skill'] = Skill::orderBy('sort_order', 'asc')->latest()->get();
            $params['classification'] = Classification::orderBy('sort_order', 'asc')->latest()->get();
            $params['level'] = Level::orderBy('sort_order', 'asc')->latest()->get();
            $params['user'] = User::latest()->get();

            if ($request->ajax()) {

                $input_category = $request['input_category'];
                $input_skill = $request['input_skill'];
                $input_classification = $request['input_classification'];
                $input_level = $request['input_level'];
                $input_user = $request['input_user'];
                $input_start_date = $request['input_start_date'];
                $input_end_date = $request['input_end_date'];

                $query = Audio_Quiz_Leaderboard::latest();
                if ($input_category != 0) {
                    $query->where('category_id', $input_category);
                }
                if ($input_skill != 0) {
                    $query->where('skill_id', $input_skill);
                }
                if ($input_classification != 0) {
                    $query->where('classification_id', $input_classification);
                }
                if ($input_level != 0) {
                    $query->where('level_id', $input_level);
                }
                if ($input_user != 0) {
                    $query->where('user_id', $input_user);
                }
                if (!empty($input_start_date)) {
                    $query->whereDate('created_at', '>=', date('Y-m-d', strtotime($input_start_date)));
                }
                if (!empty($input_end_date)) {
                    $query->whereDate('created_at', '<=', date('Y-m-d', strtotime($input_end_date)));
                }
                $data = $query->with('category', 'skill', 'classification', 'level', 'user')->latest()->get();

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('status', function ($row) {
                        if ($row->status == 1) {
                            $showLabel = __('label.passed');
                            return "<button type='button' class='show-btn'>$showLabel</button>";
                        } else {
                            $hideLabel = __('label.failed');
                            return "<button type='button' class='hide-btn'>$hideLabel</button>";
                        }
                    })
                    ->rawColumns(['status'])
                    ->make(true);
            }
            return view('admin.audio_leaderboard.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
